<?php
class ControllerProductProduct extends Controller {
	private $error = array();

	public function index() {

			$data['idquantity'] = $this->config->get('quantity_id');
			

            if (defined('OPENCARTVIP_ACTIVE')) {
                $this->opencartvip->document->addStyle('catalog/view/theme/opencartvip/lib/imagezoom/imagezoom.min.css');
			    $this->opencartvip->document->addScript('catalog/view/theme/opencartvip/lib/imagezoom/jquery.imagezoom.min.js', 'footer');

                $this->opencartvip->document->addStyle('catalog/view/theme/opencartvip/lib/lightgallery/css/lightgallery.min.css');
                $this->opencartvip->document->addScript('catalog/view/theme/opencartvip/lib/lightgallery/js/lightgallery-all.js', 'footer');

                $this->opencartvip->document->addStyle('catalog/view/theme/opencartvip/lib/swiper/swiper.min.css');
			    $this->opencartvip->document->addScript('catalog/view/theme/opencartvip/lib/swiper/swiper.min.js', 'footer');
            }
            

        $this->load->language('extension/module/notify_when_available');
        $data['text_out_of_stock'] = $this->language->get('text_out_of_stock');
        $data['out_of_stock_show'] = $this->config->get('module_notify_when_available_stock');
        $data['out_of_stock_notify'] = $this->config->get('module_notify_when_available_notify');
        
		$this->load->language('product/product');

		$data['breadcrumbs'] = array();

		$data['breadcrumbs'][] = array(
			'text' => $this->language->get('text_home'),
			'href' => $this->url->link('common/home')
		);

		$this->load->model('catalog/category');


      // path manager
      if (isset($this->request->get['product_id']) && ((!isset($this->request->get['path']) && $this->config->get('mlseo_fpp_breadcrumbs') == '1') || ($this->config->get('mlseo_fpp_breadcrumbs') == '2')) && is_array($this->request->get)) {
        unset($this->request->get['path']);
        $this->load->model('tool/path_manager');
        $this->request->get = $this->model_tool_path_manager->getFullProductPath($this->request->get['product_id'], true) + $this->request->get;
      }
			
		if (isset($this->request->get['path'])) {
			$path = '';

			$parts = explode('_', (string)$this->request->get['path']);

			$category_id = (int)array_pop($parts);

			foreach ($parts as $path_id) {
				if (!$path) {
					$path = $path_id;
				} else {
					$path .= '_' . $path_id;
				}

				$category_info = $this->model_catalog_category->getCategory($path_id);

				if ($category_info) {
					$data['breadcrumbs'][] = array(
						'text' => $category_info['name'],
						'href' => $this->url->link('product/category', 'path=' . $path)
					);
				}
			}

			// Set the last category breadcrumb
			$category_info = $this->model_catalog_category->getCategory($category_id);

			if ($category_info) {
				$url = '';

				if (isset($this->request->get['sort'])) {
					$url .= '&sort=' . $this->request->get['sort'];
				}

				if (isset($this->request->get['order'])) {
					$url .= '&order=' . $this->request->get['order'];
				}

				if (isset($this->request->get['page'])) {
					$url .= '&page=' . $this->request->get['page'];
				}

				if (isset($this->request->get['limit'])) {
					$url .= '&limit=' . $this->request->get['limit'];
				}

				$data['breadcrumbs'][] = array(
					'text' => $category_info['name'],
					'href' => $this->url->link('product/category', 'path=' . $this->request->get['path'] . $url)
				);
			}
		}

		$this->load->model('catalog/manufacturer');

		if (isset($this->request->get['manufacturer_id'])) {
			$data['breadcrumbs'][] = array(
				'text' => $this->language->get('text_brand'),
				'href' => $this->url->link('product/manufacturer')
			);

			$url = '';

			if (isset($this->request->get['sort'])) {
				$url .= '&sort=' . $this->request->get['sort'];
			}

			if (isset($this->request->get['order'])) {
				$url .= '&order=' . $this->request->get['order'];
			}

			if (isset($this->request->get['page'])) {
				$url .= '&page=' . $this->request->get['page'];
			}

			if (isset($this->request->get['limit'])) {
				$url .= '&limit=' . $this->request->get['limit'];
			}

			$manufacturer_info = $this->model_catalog_manufacturer->getManufacturer($this->request->get['manufacturer_id']);

			if ($manufacturer_info) {
				$data['breadcrumbs'][] = array(
					'text' => $manufacturer_info['name'],
					'href' => $this->url->link('product/manufacturer/info', 'manufacturer_id=' . $this->request->get['manufacturer_id'] . $url)
				);
			}
		}

		if (isset($this->request->get['search']) || isset($this->request->get['tag'])) {
			$url = '';

			if (isset($this->request->get['search'])) {
				$url .= '&search=' . $this->request->get['search'];
			}

			if (isset($this->request->get['tag'])) {
				$url .= '&tag=' . $this->request->get['tag'];
			}

			if (isset($this->request->get['description'])) {
				$url .= '&description=' . $this->request->get['description'];
			}

			if (isset($this->request->get['category_id'])) {
				$url .= '&category_id=' . $this->request->get['category_id'];
			}

			if (isset($this->request->get['sub_category'])) {
				$url .= '&sub_category=' . $this->request->get['sub_category'];
			}

			if (isset($this->request->get['sort'])) {
				$url .= '&sort=' . $this->request->get['sort'];
			}

			if (isset($this->request->get['order'])) {
				$url .= '&order=' . $this->request->get['order'];
			}

			if (isset($this->request->get['page'])) {
				$url .= '&page=' . $this->request->get['page'];
			}

			if (isset($this->request->get['limit'])) {
				$url .= '&limit=' . $this->request->get['limit'];
			}

			$data['breadcrumbs'][] = array(
				'text' => $this->language->get('text_search'),
				'href' => $this->url->link('product/search', $url)
			);
		}

		if (isset($this->request->get['product_id'])) {
			$product_id = (int)$this->request->get['product_id'];
		} else {
			$product_id = 0;
		}

		$this->load->model('catalog/product');

		$product_info = $this->model_catalog_product->getProduct($product_id);

		if ($product_info) {

            if (defined('OPENCARTVIP_ACTIVE')) {
                $this->load->language('product/compare');

                $data['text_weight'] = $this->language->get('text_weight');
                $data['text_dimension'] = $this->language->get('text_dimension');
                $data['product_quantity'] = $product_info['quantity'];
                $data['product_price_value'] = $product_info['special'] ? $product_info['special'] > 0 : $product_info['price'] > 0;
                $data['product_sku'] = $product_info['sku'];
                $data['product_upc'] = $product_info['upc'];
                $data['product_jan'] = $product_info['jan'];
                $data['product_isbn'] = $product_info['isbn'];
                $data['product_mpn'] = $product_info['mpn'];
                $data['product_length'] = $this->length->format($product_info['length'], $product_info['length_class_id']);
                $data['product_width'] = $this->length->format($product_info['width'], $product_info['length_class_id']);
                $data['product_height'] = $this->length->format($product_info['height'], $product_info['length_class_id']);
                $data['product_weight'] = $this->weight->format($product_info['weight'], $product_info['weight_class_id']);

                $data['product_labels'] = $this->opencartvip->productLabels($product_info, $product_info['price'], $product_info['special']);
                $data['product_extra_buttons'] = $this->opencartvip->productExtraButton($product_info, $product_info['price'], $product_info['special']);
                $data['product_blocks'] = array();

                foreach($this->opencartvip->productBlocks($product_info, $product_info['price'], $product_info['special']) as $module_id => $module_data) {
                    if ($module_data['position'] === 'quickview' && $this->opencartvip->document->isPopup()) {
                        $data['product_blocks']['default'][] = $this->load->controller('opencartvip/product_blocks', array('module_id' => $module_id, 'module_type' => 'product_blocks', 'product_info' => $product_info));
                    } else if (!$this->opencartvip->document->isPopup()) {
                        $data['product_blocks'][$module_data['position']][] = $this->load->controller('opencartvip/product_blocks', array('module_id' => $module_id, 'module_type' => 'product_blocks', 'product_info' => $product_info));
                    }
                }

                $this->load->model('catalog/manufacturer');

                $manufacturer_info = $this->model_catalog_manufacturer->getManufacturer($product_info['manufacturer_id']);

                if ($manufacturer_info && $manufacturer_info['image']) {
                    $data['manufacturer_image'] = $this->model_opencartvip_image->resize($manufacturer_info['image'], $this->opencartvip->settings->get('image_dimensions_manufacturer_logo.width'), $this->opencartvip->settings->get('image_dimensions_manufacturer_logo.height'), $this->opencartvip->settings->get('image_dimensions_manufacturer_logo.resize'));
                    
                } else {
                    $data['manufacturer_image'] = false;
                }

                if ($product_info['special']) {
                    $data['date_end'] = $this->opencartvip->productCountdown($product_info);
                } else {
                    $data['date_end'] = false;
                }

                if ($this->opencartvip->document->isPopup()) {
                    $data['view_more_url'] = $this->url->link('product/product', 'product_id=' . (int)$this->request->get['product_id']);
                }
            }
            

        $data['total_quantity']  = $product_info['quantity'];
        
			$url = '';

			if (isset($this->request->get['path'])) {
				$url .= '&path=' . $this->request->get['path'];
			}

			if (isset($this->request->get['filter'])) {
				$url .= '&filter=' . $this->request->get['filter'];
			}

			if (isset($this->request->get['manufacturer_id'])) {
				$url .= '&manufacturer_id=' . $this->request->get['manufacturer_id'];
			}

			if (isset($this->request->get['search'])) {
				$url .= '&search=' . $this->request->get['search'];
			}

			if (isset($this->request->get['tag'])) {
				$url .= '&tag=' . $this->request->get['tag'];
			}

			if (isset($this->request->get['description'])) {
				$url .= '&description=' . $this->request->get['description'];
			}

			if (isset($this->request->get['category_id'])) {
				$url .= '&category_id=' . $this->request->get['category_id'];
			}

			if (isset($this->request->get['sub_category'])) {
				$url .= '&sub_category=' . $this->request->get['sub_category'];
			}

			if (isset($this->request->get['sort'])) {
				$url .= '&sort=' . $this->request->get['sort'];
			}

			if (isset($this->request->get['order'])) {
				$url .= '&order=' . $this->request->get['order'];
			}

			if (isset($this->request->get['page'])) {
				$url .= '&page=' . $this->request->get['page'];
			}

			if (isset($this->request->get['limit'])) {
				$url .= '&limit=' . $this->request->get['limit'];
			}

			$data['breadcrumbs'][] = array(
				'text' => $product_info['name'],
				'href' => $this->url->link('product/product', $url . '&product_id=' . $this->request->get['product_id'])
			);

			
      if ($this->config->get('mlseo_enabled')) {
        $this->document->setTitle(!empty($product_info['meta_title']) ? $product_info['meta_title'] : $product_info['name']);
        if (version_compare(VERSION, '2', '>=')) {
          $data['image_alt'] = !empty($product_info['image_alt']) ? $product_info['image_alt'] : '';
          $data['image_title'] = !empty($product_info['image_title']) ? $product_info['image_title'] : '';
        } else {
          $this->data['image_alt'] = !empty($product_info['image_alt']) ? $product_info['image_alt'] : '';
          $this->data['image_title'] = !empty($product_info['image_title']) ? $product_info['image_title'] : '';
        }
      } else {
        $this->document->setTitle($product_info['meta_title']);
      }
      
			$this->document->setDescription($product_info['meta_description']);
			$this->document->setKeywords($product_info['meta_keyword']);
			$this->document->addLink($this->url->link('product/product', 'product_id=' . $this->request->get['product_id']), 'canonical');
			$this->document->addScript('catalog/view/javascript/jquery/magnific/jquery.magnific-popup.min.js');
			$this->document->addStyle('catalog/view/javascript/jquery/magnific/magnific-popup.css');
			$this->document->addScript('catalog/view/javascript/jquery/datetimepicker/moment/moment.min.js');
			$this->document->addScript('catalog/view/javascript/jquery/datetimepicker/moment/moment-with-locales.min.js');
			$this->document->addScript('catalog/view/javascript/jquery/datetimepicker/bootstrap-datetimepicker.min.js');
			$this->document->addStyle('catalog/view/javascript/jquery/datetimepicker/bootstrap-datetimepicker.min.css');

			$data['heading_title'] = $product_info['name'];

				$data['min'] = $product_info['minimum'];
				$data['max'] = $product_info['quantity'];
			


      if (version_compare(VERSION, '2', '>=')) {
        $data['heading_title'] = !empty($product_info['seo_h1']) && $this->config->get('mlseo_enabled') ? $product_info['seo_h1'] : $product_info['name'];
        $data['seo_h1'] = !empty($product_info['seo_h1']) ? $product_info['seo_h1'] : '';
        $data['seo_h2'] = !empty($product_info['seo_h2']) ? $product_info['seo_h2'] : '';
        $data['seo_h3'] = !empty($product_info['seo_h3']) ? $product_info['seo_h3'] : '';
      } else {
        $this->data['heading_title'] = !empty($product_info['seo_h1']) && $this->config->get('mlseo_enabled') ? $product_info['seo_h1'] : $product_info['name'];
        $this->data['seo_h1'] = !empty($product_info['seo_h1']) ? $product_info['seo_h1'] : '';
        $this->data['seo_h2'] = !empty($product_info['seo_h2']) ? $product_info['seo_h2'] : '';
        $this->data['seo_h3'] = !empty($product_info['seo_h3']) ? $product_info['seo_h3'] : '';
      }
      
      $this->load->model('catalog/review');
      
      $data['seo_reviews'] = '';
      
      if ($this->config->get('mlseo_reviews')) {
        $gkd_seo_reviews = $this->model_catalog_review->getReviewsByProductId($this->request->get['product_id'], 0, (int)$this->config->get('mlseo_reviews'));
        
        if (count($gkd_seo_reviews)) {
          $data['seo_reviews'] .= '<div class="seo_reviews">';
            foreach ($gkd_seo_reviews as $review) {
              $data['seo_reviews'] .= '<table class="table table-striped table-bordered seo_review">';
              $data['seo_reviews'] .= '<tr>';
              $data['seo_reviews'] .= '  <td style="width: 50%;"><strong>' . $review['author']. '</strong></td>';
              $data['seo_reviews'] .= '  <td class="text-right">' . $review['date_added']. '</td>';
              $data['seo_reviews'] .= '</tr>';
              $data['seo_reviews'] .= '<tr>';
              $data['seo_reviews'] .= '  <td colspan="2"><p>' . $review['text']. '</p>';
              for ($i = 1; $i <= 5; $i++) { 
                if ($review['rating'] < $i) {
                  $data['seo_reviews'] .= '    <span class="fa fa-stack"><i class="fa fa-star-o fa-stack-2x"></i></span>';
                } else {
                  $data['seo_reviews'] .= '    <span class="fa fa-stack"><i class="fa fa-star fa-stack-2x"></i><i class="fa fa-star-o fa-stack-2x"></i></span>';
                }
              }
              $data['seo_reviews'] .= '  </td>';
              $data['seo_reviews'] .= '</tr>';
              $data['seo_reviews'] .= '</table>';
            }
          $data['seo_reviews'] .= '</div>';
        }
      }
      
      if (!empty($product_info['meta_robots'])) {
        $this->document->addSeoMeta('<meta name="robots" content="'.$product_info['meta_robots'].'"/>'."\n");
      }
      
      if ($this->config->get('mlseo_header_lm_product')) {
        $array_lm = array(strtotime($product_info['date_modified']));
        
        if (strtotime($product_info['date_available']) < strtotime(date('Y-m-d'))) {
          $array_lm[] = strtotime($product_info['date_available']);
        }
        
        $special_query = $this->db->query("SELECT date_start, date_end FROM " . DB_PREFIX . "product_special ps WHERE ps.product_id = '".(int)$product_id."' AND ps.customer_group_id = '" . (int)$this->config->get('config_customer_group_id') . "' AND ((ps.date_start = '0000-00-00' OR ps.date_start < NOW()) AND (ps.date_end = '0000-00-00' OR ps.date_end > NOW()))")->row;
        
        if (!empty($special_query['date_start']) && strtotime($special_query['date_start']) < strtotime(date('Y-m-d'))) {
          $array_lm[] = strtotime($special_query['date_start']);
        }
        
        if (!empty($special_query['date_end']) && strtotime($special_query['date_end']) < strtotime(date('Y-m-d'))) {
          $array_lm[] = strtotime($special_query['date_end']);
        }
        
        $review_query = $this->db->query("SELECT date_modified FROM " . DB_PREFIX . "review WHERE product_id = '" . (int)$product_id . "' AND status = '1' ORDER BY date_modified DESC LIMIT 1")->row;
        
        if (!empty($review_query['date_modified']) && strtotime($review_query['date_modified']) < strtotime(date('Y-m-d'))) {
          $array_lm[] = strtotime($review_query['date_modified']);
        }
        
        $gkd_header_lm_date = max($array_lm);
        
        $this->response->addHeader('Last-Modified: '.date('D, d M Y H:i:s', $gkd_header_lm_date).' GMT');
      }
      
			$data['text_minimum'] = sprintf($this->language->get('text_minimum'), $product_info['minimum']);
			$data['text_login'] = sprintf($this->language->get('text_login'), $this->url->link('account/login', '', true), $this->url->link('account/register', '', true));

			$this->load->model('catalog/review');

			$data['tab_review'] = sprintf($this->language->get('tab_review'), $product_info['reviews']);

			$data['product_id'] = (int)$this->request->get['product_id'];
			$data['manufacturer'] = $product_info['manufacturer'];
			$data['manufacturers'] = $this->url->link('product/manufacturer/info', 'manufacturer_id=' . $product_info['manufacturer_id']);
			$data['model'] = $product_info['model'];
			$data['reward'] = $product_info['reward'];

				$data['telephone'] = $this->config->get('config_telephone');
			
			$data['points'] = $product_info['points'];
			$data['description'] = html_entity_decode($product_info['description'], ENT_QUOTES, 'UTF-8');

			if ($product_info['quantity'] <= 0) {
				$data['stock'] = $product_info['stock_status'];
			} elseif ($this->config->get('config_stock_display')) {
				$data['stock'] = $product_info['quantity'];
			} else {
				$data['stock'] = $this->language->get('text_instock');
			}

			$this->load->model('tool/image');

			if ($product_info['image']) {
				$data['popup'] = $this->model_tool_image->resize($product_info['image'], $this->config->get('theme_' . $this->config->get('config_theme') . '_image_popup_width'), $this->config->get('theme_' . $this->config->get('config_theme') . '_image_popup_height'));
			} else {
				$data['popup'] = '';
			}

			if ($product_info['image']) {
				$data['thumb'] = $this->model_tool_image->resize($product_info['image'], $this->config->get('theme_' . $this->config->get('config_theme') . '_image_thumb_width'), $this->config->get('theme_' . $this->config->get('config_theme') . '_image_thumb_height'));
			} else {
				$data['thumb'] = '';
			}

			$data['images'] = array();

			$results = $this->model_catalog_product->getProductImages($this->request->get['product_id']);

            if (defined('OPENCARTVIP_ACTIVE')) {
                array_unshift($results, array('image' => $product_info['image']));

                foreach ($results as $result) {
				    $data['images'][] = array(
                        'galleryThumb'  => $this->model_opencartvip_image->resize($result['image'], $this->opencartvip->settings->get('image_dimensions_popup_thumb.width'), $this->opencartvip->settings->get('image_dimensions_popup_thumb.height'), $this->opencartvip->settings->get('image_dimensions_popup_thumb.resize')),
                        'image'         => $this->model_opencartvip_image->resize($result['image'], $this->opencartvip->settings->get('image_dimensions_thumb.width'), $this->opencartvip->settings->get('image_dimensions_thumb.height'), $this->opencartvip->settings->get('image_dimensions_thumb.resize')),
                       
                        'popup'         => $this->model_opencartvip_image->resize($result['image'], $this->opencartvip->settings->get('image_dimensions_popup.width'), $this->opencartvip->settings->get('image_dimensions_popup.height'), $this->opencartvip->settings->get('image_dimensions_popup.resize')),
                        'thumb'         => $this->model_opencartvip_image->resize($result['image'], $this->opencartvip->settings->get('image_dimensions_additional.width'), $this->opencartvip->settings->get('image_dimensions_additional.height'), $this->opencartvip->settings->get('image_dimensions_additional.resize'))
                      
				    );
			    }

			    $results = array();
            }
            

			foreach ($results as $result) {
				$data['images'][] = array(
					'popup' => $this->model_tool_image->resize($result['image'], $this->config->get('theme_' . $this->config->get('config_theme') . '_image_popup_width'), $this->config->get('theme_' . $this->config->get('config_theme') . '_image_popup_height')),
					'thumb' => $this->model_tool_image->resize($result['image'], $this->config->get('theme_' . $this->config->get('config_theme') . '_image_additional_width'), $this->config->get('theme_' . $this->config->get('config_theme') . '_image_additional_height'))
				);
			}

			if ($this->customer->isLogged() || !$this->config->get('config_customer_price')) {
				$data['price'] = $this->currency->format($this->tax->calculate($product_info['price'], $product_info['tax_class_id'], $this->config->get('config_tax')), $this->session->data['currency']);
			} else {
				$data['price'] = false;
			}

			if ((float)$product_info['special']) {
				$data['special'] = $this->currency->format($this->tax->calculate($product_info['special'], $product_info['tax_class_id'], $this->config->get('config_tax')), $this->session->data['currency']);
			} else {
				$data['special'] = false;
			}

			if ($this->config->get('config_tax')) {
				$data['tax'] = $this->currency->format((float)$product_info['special'] ? $product_info['special'] : $product_info['price'], $this->session->data['currency']);
			} else {
				$data['tax'] = false;
			}

			$discounts = $this->model_catalog_product->getProductDiscounts($this->request->get['product_id']);

			$data['discounts'] = array();

			foreach ($discounts as $discount) {
				$data['discounts'][] = array(
					'quantity' => $discount['quantity'],
					'price'    => $this->currency->format($this->tax->calculate($discount['price'], $product_info['tax_class_id'], $this->config->get('config_tax')), $this->session->data['currency'])
				);
			}


        if ($data['price']) {
            $data['price'] = '<span data-value=\'' . $this->tax->calculate($product_info['price'], $product_info['tax_class_id'], $this->config->get('config_tax')) . '\' class=\'autocalc-product-price\'>' . $data['price'] . '</span>';
        }
        if ($data['special']) {
            $data['special'] = '<span data-value=\'' . $this->tax->calculate($product_info['special'], $product_info['tax_class_id'], $this->config->get('config_tax')) . '\' class=\'autocalc-product-special\'>' . $data['special'] . '</span>';
        }
        if ($data['points']) {
            $data['points'] = '<span data-value=\'' . $product_info['points'] . '\' class=\'autocalc-product-points\'>' . $data['points'] . '</span>';
        }
        if ($data['tax']) {
            $data['tax'] = '<span data-value=\'' . (float)($product_info['special'] ? $product_info['special'] : $product_info['price']) . '\' class=\'autocalc-product-tax\'>' . $data['tax'] . '</span>';
        }
        
        $data['apo_price_value'] = $product_info['price'];
        $data['apo_special_value'] = $product_info['special'];
        $data['apo_tax_value'] = (float)$product_info['special'] ? $product_info['special'] : $product_info['price'];
        $data['apo_points_value'] = $product_info['points'];
        
        $currency_code = $this->session->data['currency'];
        $data['autocalc_currency'] = array(
            'value'           => (float)$this->currency->getValue($currency_code),
            'symbol_left'     => str_replace("'", "\'", $this->currency->getSymbolLeft($currency_code)),
            'symbol_right'    => str_replace("'", "\'", $this->currency->getSymbolRight($currency_code)),
            'decimals'        => (int)$this->currency->getDecimalPlace($currency_code),
            'decimal_point'   => $this->language->get('decimal_point'),
            'thousand_point'  => $this->language->get('thousand_point'),
        );
        

        $currency2_code = $this->config->get('config_currency2');
        if ($this->currency->has($currency2_code) && $currency2_code != $currency_code) {
            $currency_code = $currency2_code;
            $data['autocalc_currency2'] = array(
                'value'           => (float)$this->currency->getValue($currency_code),
                'symbol_left'     => str_replace("'", "\'", $this->currency->getSymbolLeft($currency_code)),
                'symbol_right'    => str_replace("'", "\'", $this->currency->getSymbolRight($currency_code)),
                'decimals'        => (int)$this->currency->getDecimalPlace($currency_code),
                'decimal_point'   => $this->language->get('decimal_point'),
                'thousand_point'  => $this->language->get('thousand_point'),
            );
        }
        
        $data['discounts_raw'] = $discounts;

        $data['tax_class_id'] = $product_info['tax_class_id'];
        $data['tax_rates'] = $this->tax->getRates(0, $product_info['tax_class_id']);
      
        $data['autocalc_option_special'] = $this->config->get('config_autocalc_option_special');
        $data['autocalc_option_discount'] = $this->config->get('config_autocalc_option_discount');
        $data['autocalc_not_mul_qty'] = $this->config->get('config_autocalc_not_mul_qty');
        $data['autocalc_select_first'] = $this->config->get('config_autocalc_select_first');
      

        $owq_of_data = array();
      
			$data['options'] = array();

			foreach ($this->model_catalog_product->getProductOptions($this->request->get['product_id']) as $option) {
				$product_option_value_data = array();

				foreach ($option['product_option_value'] as $option_value) {
					if (!$option_value['subtract'] || ($option_value['quantity'] > 0)) {
						if ((($this->config->get('config_customer_price') && $this->customer->isLogged()) || !$this->config->get('config_customer_price')) && (float)$option_value['price']) {
							$price = $this->currency->format($this->tax->calculate($option_value['price'], $product_info['tax_class_id'], $this->config->get('config_tax') ? 'P' : false), $this->session->data['currency']);

        if ($this->config->get('config_autocalc_hide_option_price')) $price = false;
      
						} else {
							$price = false;
						}


        if ($price) {
            switch ($option_value['price_prefix']) {
                case '%':
                    $price = ($option_value['price'] > 0 ? '+' : '') . (float)$option_value['price'] . '%';
                    break;
                case '*':
                    $price = '*' . (float)$option_value['price'];
                    break;
                case '/':
                    $price = '/' . (float)$option_value['price'];
                    break;
            }
        }
        if ($this->config->get('config_autocalc_hide_option_price')) $price = false;
      

        if (!empty($option_value['model'])) {
            $owq_of_data[$option_value['product_option_value_id']] = array(
                'model'       => $option_value['model'],
            );
        }
      
						$product_option_value_data[] = array(

        'apo_price_value'               => $option_value['price'],
        'apo_points_value'              => isset($option_value['points_prefix']) && $option_value['points'] ? intval($option_value['points_prefix'].$option_value['points']) : 0,
      
							'product_option_value_id' => $option_value['product_option_value_id'],
							'option_value_id'         => $option_value['option_value_id'],
							'name'                    => $option_value['name'],
							'quantity'             => $option_value['quantity'],
							
            'image'                   => defined('OPENCARTVIP_ACTIVE') ? ($option_value['image'] ? $this->model_opencartvip_image->resize($option_value['image'], $this->opencartvip->settings->get('image_dimensions_options.width'), $this->opencartvip->settings->get('image_dimensions_options.height'), $this->opencartvip->settings->get('image_dimensions_options.resize')) : false) : $this->model_tool_image->resize($option_value['image'], 50, 50),
            
							'price'                   => $price,
							'price_prefix'            => $option_value['price_prefix']
						);
					}
				}

				$data['options'][] = array(
					'product_option_id'    => $option['product_option_id'],
					'product_option_value' => $product_option_value_data,
					'option_id'            => $option['option_id'],
					'name'                 => $option['name'],
					'type'                 => $option['type'],
					'value'                => $option['value'],
					'required'             => $option['required']
				);
			}


        $data['owq_of_data'] = $owq_of_data ? json_encode($owq_of_data, true) : false;
        $data['owq_description_selector'] = '#tab-description';
      
			if ($product_info['minimum']) {
				$data['minimum'] = $product_info['minimum'];
			} else {
				$data['minimum'] = 1;
			}

			$data['review_status'] = $this->config->get('config_review_status');

			if ($this->config->get('config_review_guest') || $this->customer->isLogged()) {
				$data['review_guest'] = true;
			} else {
				$data['review_guest'] = false;
			}

			if ($this->customer->isLogged()) {
				$data['customer_name'] = $this->customer->getFirstName() . '&nbsp;' . $this->customer->getLastName();
			} else {
				$data['customer_name'] = '';
			}

			$data['reviews'] = sprintf($this->language->get('text_reviews'), (int)$product_info['reviews']);
			$data['rating'] = (int)$product_info['rating'];

			$data['reviewprostatus'] = $this->config->get('reviewpro_fields')['status'];
			$data['forstars'] = '';
			$data['reviewfeatured'] = '';
			$data['reviewstotal'] = '';
				if($this->config->get('reviewpro_fields')['status']){
					$this->load->model('extension/reviewpro');
					$this->load->language('extension/reviewpro');
					
					$data['entry_title'] = $this->language->get('entry_title');
					$data['entry_email'] = $this->language->get('entry_email');
					$data['entry_comment'] = $this->language->get('entry_comment');
					$data['entry_rating'] = $this->language->get('entry_rating');
					$data['entry_attachment'] = $this->language->get('entry_attachment');
					$data['text_verified'] = $this->language->get('text_verified');
					$data['text_featured_reviews'] = $this->language->get('text_featured_reviews');
					$data['text_clearfilter'] = $this->language->get('text_clearfilter');
					$data['text_descending'] = $this->language->get('text_descending');
					$data['text_asc'] = $this->language->get('text_asc');
					$data['text_no_reviews'] = $this->language->get('text_no_reviews');
					
					$data['reviewprostatus'] = $this->config->get('reviewpro_fields')['status'];
					$data['review_status'] = $this->config->get('reviewpro_fields')['status'];
					$data['displayform'] = $this->config->get('reviewpro_fields')['displayform'];
					$data['reviewpro_fields'] = $this->config->get('reviewpro_fields');
					if(isset($this->config->get('reviewpro_fields')['filter'])){
						$data['reviewfilters'] = $this->config->get('reviewpro_fields')['filter'];
					}else{
						$data['reviewfilters'] = '';
					}
					
					if(isset($this->config->get('reviewpro_fields')['reviewsnippet'])){
						$data['reviewsnippet'] = $this->config->get('reviewpro_fields')['reviewsnippet'];
					}else{
						$data['reviewsnippet'] = '';
					}
					$data['meta_descriptions'] = html_entity_decode($product_info['meta_description'], ENT_QUOTES, 'UTF-8');
					
					$data['product_id'] = $this->request->get['product_id'];
					
					$data['ratinglists'] = $this->model_extension_reviewpro->getratinglist();
					$data['textadmin'] = $this->config->get('reviewpro_fields')['overall'][$this->config->get('config_language_id')];
					$data['votetext'] = $this->config->get('reviewpro_fields')[$this->config->get('config_language_id')];
					$data['product_name'] = $this->model_catalog_product->getProduct($this->request->get['product_id'])['name'];
					$data['rating_desc'] = $this->model_extension_reviewpro->getratinglist();
					$data['review_total'] = $this->model_extension_reviewpro->getTotalReviewsByProductId($this->request->get['product_id']);
					$data['tab_review'] = sprintf($this->language->get('tab_review'), $data['review_total']);
					$data['reviewtotals'] = sprintf($this->language->get('text_reviews'), (int)$data['review_total']);
					$data['reviewform'] = $this->config->get('reviewpro_fields')['reviewform'][$this->config->get('config_language_id')];
					
					if ($this->config->get('reviewpro_fields')['guestreview'] || $this->customer->isLogged()) {
						$data['review_guest'] = true;
					} else {
						$data['review_guest'] = false;
					}
					if ($this->customer->isLogged()) {
						$data['customer_email'] = $this->customer->getEmail();
					} else {
						$data['customer_email'] = '';
					}
					
					if ($this->config->get('reviewpro_fields')['guestreview']) {
						$data['guestreview'] = true;
					}elseif($this->customer->isLogged() && !$this->config->get('reviewpro_fields')['guestreview']){
						$data['guestreview'] = true;
					}else{
						$data['guestreview'] = false;
					}
					
					$data['text_descending'] = $this->language->get('text_descending');
					$data['text_asc'] = $this->language->get('text_asc');
 				
					if (isset($this->request->get['page'])) {
						$page = $this->request->get['page'];
					} else {
						$page = 1;
					}

					if (isset($this->request->get['rating_id'])) {
						$rating_id = $this->request->get['rating_id'];
					}else{
						$rating_id = '0';
					}
					
					if (isset($this->request->get['ratings'])) {
						$ratings = $this->request->get['ratings'];
					}else{
						$ratings = '0';
					}
					
					if($this->config->get('reviewpro_fields')['noofreview']){
						$noofreview = $this->config->get('reviewpro_fields')['noofreview'];
					}else{
						$noofreview = 5;
					}
					
					$filter_data = array(
						'rating_id'  => $rating_id,
						'ratings'  => $ratings,
						'limit' => $noofreview,
						'start' => ($page - 1) * $noofreview,
					);
					
					$data['allreviews'] = array();
					
					$reviewss = $this->model_extension_reviewpro->getReviewsByProductId($this->request->get['product_id'],$filter_data);
					$data['reviewfeatured'] = $this->model_extension_reviewpro->getfeaturedReviewsByProductId($this->request->get['product_id'], $filter_data);
					
					foreach($reviewss as $review){
						$ratingss = $this->model_extension_reviewpro->getreviewrating($review['review_id']);
						$i = 0;
						$ratingvalue = array();
						foreach($ratingss as $ratings){
							$ratingvalue[] = $ratings['rating'];
							$i++;
						}
						if(!empty($ratingvalue)){
							$sumrating = array_sum($ratingvalue) / $i;
						}
						$data['allreviews'][] = array(
							'name' => $review['name'],
							'comment' => $review['comment'],
							'date_added' => $review['date_added'],
							'sumrating' => isset($sumrating) ? $sumrating : ''
						);
					}
					
					$data['avgrating'] = array();
					$total_avg = 0;
					$items = 0;
					foreach ($data['rating_desc'] as $result) {
						$count = $this->model_extension_reviewpro->getratingparcount($result['rating_id'], $this->request->get['product_id']);
						$sum = $this->model_extension_reviewpro->getratingparsum($result['rating_id'], $this->request->get['product_id']);
						$avg = $this->model_extension_reviewpro->getratingparavg($result['rating_id'], $this->request->get['product_id']);
						$per = $avg*100/5;
						if($count){
							$data['avgrating'][$result['rating_id']] = array(
								'count'       => $count,
								'sum'     	  => $sum,
								'average'     => $avg,
								'per'     	  => round($per,1).'%'
							);
							$total_avg = $avg + $total_avg;
							$items++;
						}
					}
					if($total_avg){
						$data['averagerating'] = round($total_avg / $items, 1);
					}else{
						$data['averagerating'] = 0;
					}
					$data['forstars'] = round($data['averagerating']);
					$data['reviewstotal'] = sprintf($this->language->get('text_reviews'), $data['review_total']);
					if(!empty($total_avg) && !empty($items)){
						$data['rating'] = round($total_avg / $items);
					}else{
						$data['rating'] = '';
					}
					$data['getcurrencycode'] = $this->session->data['currency'];
					
					if ($this->customer->isLogged() || !$this->config->get('config_customer_price')) {
						$data['reviewprice'] = $this->currency->format($this->tax->calculate($product_info['price'], $product_info['tax_class_id'], $this->config->get('config_tax')), $this->session->data['currency'] , '' , false);
					} else {
						$data['reviewprice'] = false;
					}
					if ((float)$product_info['special']) {
						$data['reviewspecial'] = $this->currency->format($this->tax->calculate($product_info['special'], $product_info['tax_class_id'], $this->config->get('config_tax')), $this->session->data['currency'] , '' , false);
					} else {
						$data['reviewspecial'] = false;
					}
				}
			
			

			// Captcha
			if ($this->config->get('captcha_' . $this->config->get('config_captcha') . '_status') && in_array('review', (array)$this->config->get('config_captcha_page'))) {
				$data['captcha'] = $this->load->controller('extension/captcha/' . $this->config->get('config_captcha'));
			} else {
				$data['captcha'] = '';
			}

			$data['share'] = $this->url->link('product/product', 'product_id=' . (int)$this->request->get['product_id']);

			$data['attribute_groups'] = $this->model_catalog_product->getProductAttributes($this->request->get['product_id']);

			$data['products'] = array();

			$results = defined('OPENCARTVIP_ACTIVE') ? array() : $this->model_catalog_product->getProductRelated($this->request->get['product_id']);

			foreach ($results as $result) {
				if ($result['image']) {
					$image = $this->model_tool_image->resize($result['image'], $this->config->get('theme_' . $this->config->get('config_theme') . '_image_related_width'), $this->config->get('theme_' . $this->config->get('config_theme') . '_image_related_height'));
				} else {
					$image = $this->model_tool_image->resize('placeholder.png', $this->config->get('theme_' . $this->config->get('config_theme') . '_image_related_width'), $this->config->get('theme_' . $this->config->get('config_theme') . '_image_related_height'));
				}

				if ($this->customer->isLogged() || !$this->config->get('config_customer_price')) {
					$price = $this->currency->format($this->tax->calculate($result['price'], $result['tax_class_id'], $this->config->get('config_tax')), $this->session->data['currency']);
				} else {
					$price = false;
				}

				if ((float)$result['special']) {
					$special = $this->currency->format($this->tax->calculate($result['special'], $result['tax_class_id'], $this->config->get('config_tax')), $this->session->data['currency']);
				} else {
					$special = false;
				}

				if ($this->config->get('config_tax')) {
					$tax = $this->currency->format((float)$result['special'] ? $result['special'] : $result['price'], $this->session->data['currency']);
				} else {
					$tax = false;
				}

				if ($this->config->get('config_review_status')) {
					$rating = (int)$result['rating'];
				} else {
					$rating = false;
				}


			if(isset($product_info)){
				$value = $product_info;
			}elseif(isset($result)){
				$value = $result;
			}elseif(isset($product)){
				$value = $product;
			}
			

				if($this->config->get('reviewpro_fields')['status']){
					$this->load->model('extension/reviewpro');
					$rating_desc = $this->model_extension_reviewpro->getratinglist();
					$avgrating = array();
					$total_avg = 0;
					$items = 0;
					foreach ($rating_desc as $rating_result) {
						$count = $this->model_extension_reviewpro->getratingparcount($rating_result['rating_id'],$result['product_id']);
						$avg = $this->model_extension_reviewpro->getratingparavg($rating_result['rating_id'], $result['product_id']);
						if($count){
							$total_avg = $avg + $total_avg;
							$items++;
						}
					}
					if($total_avg){
						$averagerating = round($total_avg / $items, 1);
					}else{
						$averagerating = 0;
					}
					$rating = round($averagerating);
				}
			
				$data['products'][] = array(
					'product_id'  => $result['product_id'],

        'quantity'  => $result['quantity'],
        
					'thumb'       => $image,
					'name'        => $result['name'],
					'description' => utf8_substr(trim(strip_tags(html_entity_decode($result['description'], ENT_QUOTES, 'UTF-8'))), 0, $this->config->get('theme_' . $this->config->get('config_theme') . '_product_description_length')) . '..',
					'price'       => $price,
					'special'     => $special,
					'tax'         => $tax,
'max'         => $value['quantity'],
						  'min'         => $value['minimum'],	
			
					'minimum'     => $result['minimum'] > 0 ? $result['minimum'] : 1,
					'rating'      => $rating,
					'href'        => $this->url->link('product/product', 'product_id=' . $result['product_id'])
				);
			}

			$data['tags'] = array();

			if ($product_info['tag']) {
				$tags = explode(',', $product_info['tag']);

				foreach ($tags as $tag) {
					$data['tags'][] = array(
						'tag'  => trim($tag),
						'href' => $this->url->link('product/search', 'tag=' . trim($tag))
					);
				}
			}

			$data['recurrings'] = $this->model_catalog_product->getProfiles($this->request->get['product_id']);

        $data['downloads'] = array();

        $results = $this->model_catalog_product->getDownloads($this->request->get['product_id']);

        foreach ($results as $result) {  
		  $size = false;
          $file_exists = file_exists(DIR_DOWNLOAD . $result['filename']);
          $http = preg_match('/^http/',$result['filename']);
          if ($file_exists OR $http) {
            if ($file_exists) {
              $size = filesize(DIR_DOWNLOAD . $result['filename']);
              $i = 0;
              $suffix = array( 'B', 'KB', 'MB', 'GB', 'TB', 'PB', 'EB', 'ZB', 'YB' );
              while (($size / 1024) > 1) {
              $size = $size / 1024;
              $i++;
              }
            }

            $data['downloads'][] = array(
            'date_added' => date($this->language->get('date_format_short'), strtotime($result['date_added'])),
            'name' => $result['name'],
            'size' => ($size)?round(substr($size, 0, strpos($size, '.') + 4), 2) . $suffix[$i]:false,
            'href' => ($http)?$result['filename']:$this->url->link('product/product/download', 'product_id='. $this->request->get['product_id']. '&download_id=' . $result['download_id']),
            'icon' => ($http)?'fa fa-external-link-square text-primary':'fa fa-download text-success'
            );
          }
        }
		
//BOF Product Series 
			//get link of linked products + colors
			$pds_allow_buying_series = $this->getData('pds_allow_buying_series', 0);
			
			$this->load->model('catalog/product_master');
			$results = $this->model_catalog_product_master->getLinkedProducts($this->request->get['product_id'], '2', $pds_allow_buying_series); //'2' is Image
			
			$data['pds'] = array();
			
			$pds_detail_thumbnail_width = $this->getData('pds_detail_thumbnail_width', 50);
			$pds_detail_thumbnail_height = $this->getData('pds_detail_thumbnail_height', 50);
			$pds_preview_width = $this->getData('pds_preview_width', 200);
			$pds_preview_height = $this->getData('pds_preview_height', 200);
			$data['pds_enable_preview'] = $this->getData('pds_enable_preview', 1);
			
			foreach ($results as $result)
			{
				$product_pds_image = ($result['special_attribute_value'] != '' && strtolower($result['special_attribute_value']) != 'no_image.png')
					? $this->model_tool_image->resize($result['special_attribute_value'], $pds_detail_thumbnail_width, $pds_detail_thumbnail_height)
					: $this->model_tool_image->resize($result['image'], $pds_detail_thumbnail_width, $pds_detail_thumbnail_height);
				
				$product_main_image = ($result['image'] != '' && strtolower($result['image']) != 'no_image.png')
					? $this->model_tool_image->resize($result['image'], $pds_preview_width, $pds_preview_height) //user default main image
					: $this->model_tool_image->resize($result['special_attribute_value'], $pds_preview_width, $pds_preview_height); // use series image
			
				$data['pds'][] = array(
					'product_id' => $result['product_id'],
					'product_link' => $this->url->link('product/product', $url . '&product_id=' . $result['product_id']),
					'product_name' => $result['name'],
					'product_pds_image' => $product_pds_image,
					'product_main_image' => $product_main_image
				);
			}
			
			$this->load->model('catalog/product_master');
			$this->load->language('product/pds');
			
			if(!isset($data['display_add_to_cart']))
			{
				$is_master = $this->model_catalog_product_master->isMaster($this->request->get['product_id'], '2'); //2 is Image
				$pds_allow_buying_series = $this->getData('pds_allow_buying_series', 0);
				$data['display_add_to_cart'] = !$is_master || $pds_allow_buying_series;
				$data['no_add_to_cart_message'] = $this->language->get('text_select_series_item');
			}
			
			$data['text_in_the_same_series'] = $this->language->get('text_in_the_same_series');
			//EOF Product Series 
			$this->model_catalog_product->updateViewed($this->request->get['product_id']);

      if ($this->config->get('mlseo_enabled')) {
        $this->load->model('tool/seo_package');
        
        if ($this->config->get('mlseo_multistore') && $this->config->get('config_store_id')) {
          $seoDescription = $this->model_tool_seo_package->getSeoDescription('product', $product_info['product_id']);
          
          if (isset($seoDescription['meta_title'])) {
            $this->document->setTitle($seoDescription['meta_title']);
            $product_info['meta_title'] = $seoDescription['meta_title'];
          }
          
          if (isset($seoDescription['meta_description'])) {
            $this->document->setDescription($seoDescription['meta_description']);
            $product_info['meta_description'] = $seoDescription['meta_description'];
          }
          
          if (isset($seoDescription['meta_keyword'])) {
            $this->document->setKeywords($seoDescription['meta_keyword']);
          }
          
          if (isset($seoDescription['image_alt'])) {
            $data['image_alt'] = $seoDescription['image_alt'];
          }
          
          if (isset($seoDescription['image_title'])) {
            $data['image_title'] = $seoDescription['image_title'];
          }
          
          if (isset($seoDescription['name'])) {
            $data['heading_title'] = $seoDescription['name'];
          }
          
          if (isset($seoDescription['description'])) {
            $data['description'] = html_entity_decode($seoDescription['description'], ENT_QUOTES, 'UTF-8');
          }
          
          if (isset($seoDescription['seo_h1'])) {
            $data['seo_h1'] = $seoDescription['seo_h1'];
          }
          
          if (isset($seoDescription['seo_h2'])) {
            $data['seo_h2'] = $seoDescription['seo_h2'];
          }
          
          if (isset($seoDescription['seo_h3'])) {
            $data['seo_h3'] = $seoDescription['seo_h3'];
          }
        }
        
        
        if ($this->config->get('mlseo_opengraph')) {
          if (version_compare(VERSION, '2', '>=')) {
            $this->document->addSeoMeta($this->model_tool_seo_package->rich_snippet('opengraph', 'product', $data + array('product_info' => $product_info)));
          } else {
            $this->document->addSeoMeta($this->model_tool_seo_package->rich_snippet('opengraph', 'product', $this->data + array('product_info' => $product_info)));
          }
        }

        if ($this->config->get('mlseo_tcard')) {
          if (version_compare(VERSION, '2', '>=')) {
            $this->document->addSeoMeta($this->model_tool_seo_package->rich_snippet('tcard', 'product', $data + array('product_info' => $product_info)));
          } else {
            $this->document->addSeoMeta($this->model_tool_seo_package->rich_snippet('tcard', 'product', $this->data + array('product_info' => $product_info)));
          }
        }

        if ($this->config->get('mlseo_microdata')) {
          if (version_compare(VERSION, '2', '>=')) {
            $this->document->addSeoMeta($this->model_tool_seo_package->rich_snippet('microdata', 'product', $data + array('product_info' => $product_info)));
          } else {
            $this->document->addSeoMeta($this->model_tool_seo_package->rich_snippet('microdata', 'product', $this->data + array('product_info' => $product_info)));
          }
        }
      }
      

				// << Related Options  
				$this->load->model('extension/liveopencart/related_options');
				$data = $this->model_extension_liveopencart_related_options->getProductControllerData( (!empty($data) ? $data : array()) );
				if ( $data['ro_installed'] && !empty($data['ro_scripts']) ) {
					foreach ( $data['ro_scripts'] as $ro_script ) {
						$this->document->addScript($ro_script);
					}
				}
				// >> Related Options
			

            if (defined('OPENCARTVIP_ACTIVE')) {
                $this->load->model('opencartvip/product');
                $this->model_opencartvip_product->addRecentlyViewedProduct($this->request->get['product_id']);

                $data['products_sold'] = $this->model_opencartvip_product->getProductsSold($this->request->get['product_id']);
                $data['product_views'] = $product_info['viewed'];
            }
            

	
			$data['column_left'] = $this->load->controller('common/column_left');
			$data['column_right'] = $this->load->controller('common/column_right');
			$data['content_top'] = $this->load->controller('common/content_top');
			$data['content_bottom'] = $this->load->controller('common/content_bottom');
			$data['footer'] = $this->load->controller('common/footer');
			$data['header'] = $this->load->controller('common/header');

			$this->response->setOutput($this->load->view('product/product', $data));
		} else {
			$url = '';

			if (isset($this->request->get['path'])) {
				$url .= '&path=' . $this->request->get['path'];
			}

			if (isset($this->request->get['filter'])) {
				$url .= '&filter=' . $this->request->get['filter'];
			}

			if (isset($this->request->get['manufacturer_id'])) {
				$url .= '&manufacturer_id=' . $this->request->get['manufacturer_id'];
			}

			if (isset($this->request->get['search'])) {
				$url .= '&search=' . $this->request->get['search'];
			}

			if (isset($this->request->get['tag'])) {
				$url .= '&tag=' . $this->request->get['tag'];
			}

			if (isset($this->request->get['description'])) {
				$url .= '&description=' . $this->request->get['description'];
			}

			if (isset($this->request->get['category_id'])) {
				$url .= '&category_id=' . $this->request->get['category_id'];
			}

			if (isset($this->request->get['sub_category'])) {
				$url .= '&sub_category=' . $this->request->get['sub_category'];
			}

			if (isset($this->request->get['sort'])) {
				$url .= '&sort=' . $this->request->get['sort'];
			}

			if (isset($this->request->get['order'])) {
				$url .= '&order=' . $this->request->get['order'];
			}

			if (isset($this->request->get['page'])) {
				$url .= '&page=' . $this->request->get['page'];
			}

			if (isset($this->request->get['limit'])) {
				$url .= '&limit=' . $this->request->get['limit'];
			}

			$data['breadcrumbs'][] = array(
				'text' => $this->language->get('text_error'),
				'href' => $this->url->link('product/product', $url . '&product_id=' . $product_id)
			);

			$this->document->setTitle($this->language->get('text_error'));

			$data['continue'] = $this->url->link('common/home');

			$this->response->addHeader($this->request->server['SERVER_PROTOCOL'] . ' 404 Not Found');

			$data['column_left'] = $this->load->controller('common/column_left');
			$data['column_right'] = $this->load->controller('common/column_right');
			$data['content_top'] = $this->load->controller('common/content_top');
			$data['content_bottom'] = $this->load->controller('common/content_bottom');
			$data['footer'] = $this->load->controller('common/footer');
			$data['header'] = $this->load->controller('common/header');

			$this->response->setOutput($this->load->view('error/not_found', $data));
		}
	}


			public function download() {

			$this->load->model('catalog/product');

			if (isset($this->request->get['download_id'])) {
			$download_id = $this->request->get['download_id'];
			} else {
			$download_id = 0;
			}

			if (isset($this->request->get['product_id'])) {
			$product_id = $this->request->get['product_id'];
			} else {
			$product_id = 0;
			}

			$download_info = $this->model_catalog_product->getDownload($product_id, $download_id);

			if ($download_info) {
			$file = DIR_DOWNLOAD . $download_info['filename'];
			$mask = basename($download_info['mask']);

			if (!headers_sent()) {
			if (file_exists($file)) { 
      //$finfo = new finfo(FILEINFO_MIME);
      //$mime_type = $finfo->file($file);         
      $mime_type = 'application/octet-stream';         
      
			header('Content-Description: File Transfer');
			header('Content-Type: '.$mime_type); //application/octet-stream
			header('Content-Disposition: inline; filename="' . ($mask ? $mask : basename($file)) . '"');   //attachment
			header('Content-Transfer-Encoding: binary');
			header('Expires: 0');
			header('Cache-Control: must-revalidate, post-check=0, pre-check=0');
			header('Pragma: public');
			header('Content-Length: ' . filesize($file));

			readfile($file, 'rb');

			//$this->model_account_download->updateRemaining($this->request->get['download_id']);

			exit;
			} else {
			exit('Error: Could not find file ' . $file . '!');
			}
			} else {
			exit('Error: Headers already sent out!');
			}
			} else {
			$this->redirect(HTTP_SERVER . 'index.php?route=account/download');
			}
			}
		
	public function review() {

    // SEO Package - redirect non-ajax requests
    if($this->config->get('mlseo_redir_reviews') && !(!empty($_SERVER['HTTP_X_REQUESTED_WITH']) && strtolower($_SERVER['HTTP_X_REQUESTED_WITH']) == 'xmlhttprequest')) {
      header('HTTP/1.1 301 Moved Permanently');
      header('Location: ' . $this->url->link('product/product', 'product_id=' . $this->request->get['product_id']));
    }
			
		$this->load->language('product/product');

		$this->load->model('catalog/review');

		if (isset($this->request->get['page'])) {
			$page = $this->request->get['page'];
		} else {
			$page = 1;
		}

		$data['reviews'] = array();

		$review_total = $this->model_catalog_review->getTotalReviewsByProductId($this->request->get['product_id']);

		$results = $this->model_catalog_review->getReviewsByProductId($this->request->get['product_id'], ($page - 1) * 5, 5);

		foreach ($results as $result) {
			$data['reviews'][] = array(
				'author'     => $result['author'],
				'text'       => nl2br($result['text']),
				'rating'     => (int)$result['rating'],
				'date_added' => date($this->language->get('date_format_short'), strtotime($result['date_added']))
			);
		}

		$pagination = new Pagination();
		$pagination->total = $review_total;
		$pagination->page = $page;
		$pagination->limit = 5;
		$pagination->url = $this->url->link('product/product/review', 'product_id=' . $this->request->get['product_id'] . '&page={page}');

		$data['pagination'] = $pagination->render();

		$data['results'] = sprintf($this->language->get('text_pagination'), ($review_total) ? (($page - 1) * 5) + 1 : 0, ((($page - 1) * 5) > ($review_total - 5)) ? $review_total : ((($page - 1) * 5) + 5), $review_total, ceil($review_total / 5));

		$this->response->setOutput($this->load->view('product/review', $data));
	}

	public function write() {
		$this->load->language('product/product');

		$json = array();

		if ($this->request->server['REQUEST_METHOD'] == 'POST') {
			if ((utf8_strlen($this->request->post['name']) < 3) || (utf8_strlen($this->request->post['name']) > 25)) {
				$json['error'] = $this->language->get('error_name');
			}

			if ((utf8_strlen($this->request->post['text']) < 25) || (utf8_strlen($this->request->post['text']) > 1000)) {
				$json['error'] = $this->language->get('error_text');
			}

			if (empty($this->request->post['rating']) || $this->request->post['rating'] < 0 || $this->request->post['rating'] > 5) {
				$json['error'] = $this->language->get('error_rating');
			}

			// Captcha
			if ($this->config->get('captcha_' . $this->config->get('config_captcha') . '_status') && in_array('review', (array)$this->config->get('config_captcha_page'))) {
				$captcha = $this->load->controller('extension/captcha/' . $this->config->get('config_captcha') . '/validate');

				if ($captcha) {
					$json['error'] = $captcha;
				}
			}

			if (!isset($json['error'])) {
				$this->load->model('catalog/review');

				$this->model_catalog_review->addReview($this->request->get['product_id'], $this->request->post);

				$json['success'] = $this->language->get('text_success');
			}
		}

		$this->response->addHeader('Content-Type: application/json');
		$this->response->setOutput(json_encode($json));
	}

	public function getRecurringDescription() {
		$this->load->language('product/product');
		$this->load->model('catalog/product');

		if (isset($this->request->post['product_id'])) {
			$product_id = $this->request->post['product_id'];
		} else {
			$product_id = 0;
		}

		if (isset($this->request->post['recurring_id'])) {
			$recurring_id = $this->request->post['recurring_id'];
		} else {
			$recurring_id = 0;
		}

		if (isset($this->request->post['quantity'])) {
			$quantity = $this->request->post['quantity'];
		} else {
			$quantity = 1;
		}

		$product_info = $this->model_catalog_product->getProduct($product_id);
		
		$recurring_info = $this->model_catalog_product->getProfile($product_id, $recurring_id);

		$json = array();

		if ($product_info && $recurring_info) {
			if (!$json) {
				$frequencies = array(
					'day'        => $this->language->get('text_day'),
					'week'       => $this->language->get('text_week'),
					'semi_month' => $this->language->get('text_semi_month'),
					'month'      => $this->language->get('text_month'),
					'year'       => $this->language->get('text_year'),
				);

				if ($recurring_info['trial_status'] == 1) {
					$price = $this->currency->format($this->tax->calculate($recurring_info['trial_price'] * $quantity, $product_info['tax_class_id'], $this->config->get('config_tax')), $this->session->data['currency']);
					$trial_text = sprintf($this->language->get('text_trial_description'), $price, $recurring_info['trial_cycle'], $frequencies[$recurring_info['trial_frequency']], $recurring_info['trial_duration']) . ' ';
				} else {
					$trial_text = '';
				}

				$price = $this->currency->format($this->tax->calculate($recurring_info['price'] * $quantity, $product_info['tax_class_id'], $this->config->get('config_tax')), $this->session->data['currency']);

				if ($recurring_info['duration']) {
					$text = $trial_text . sprintf($this->language->get('text_payment_description'), $price, $recurring_info['cycle'], $frequencies[$recurring_info['frequency']], $recurring_info['duration']);
				} else {
					$text = $trial_text . sprintf($this->language->get('text_payment_cancel'), $price, $recurring_info['cycle'], $frequencies[$recurring_info['frequency']], $recurring_info['duration']);
				}

				$json['success'] = $text;
			}
		}

		$this->response->addHeader('Content-Type: application/json');
		$this->response->setOutput(json_encode($json));
	}
}
