<?php
$_['promotions'] = array(
    'title'         => 'Kampanya Oluştur',
    'name'          => $name = 'promotions',
    'version'       => '1.0' ,

    // Internal
    'code'          => 'module_' . $name,
    'path'          => 'extension/module/' . $name,
    'model'         => 'model_extension_module_' . $name,
    'ext_link'      => 'marketplace/extension',
    'ext_type'      => '&type=module',

    'total_code'    => 'total_' . $name . '_total',
    'total_path'    => 'extension/total/' . $name . '_total',
    'total_model'   => 'model_extension_total_' . $name . '_total',
    'total_link'    => 'marketplace/extension',
    'total_type'    => '&type=total',

    'url_token'     => 'user_token=%s',
    'store_id'      => 0,

    // Default setting
    'setting'   => array(
        'status'    => '0',
        'test_mode' => '0',
        'module'    => array(
            'title'         => '',
            'status'        => '0',
            'limit'         => '3',
            'sort_order'    => 'priority',
            'custom_css'    => '/* Set limit to 7, 4 banner on 2nd row for desktop and up */
@media (min-width: 992px) {
    .islpr-banner-item:nth-child(n+4) { width: 25%; }
}',
        ),
        'page'      => array(
            'title'         => '',
            'status'        => '0',
            'navbar'        => '1',
            'banner'        => '',
            'content'        => '',
            'custom_css'    => '/* Custom banner width */
@media (min-width: 992px) {
  .islpr-banner-item:nth-child(4),
  .islpr-banner-item:nth-child(12),
  .islpr-banner-item:nth-child(13) { width: 50%; }

  .islpr-banner-item:nth-child(5),
  .islpr-banner-item:nth-child(6),
  .islpr-banner-item:nth-child(7),
  .islpr-banner-item:nth-child(8)  { width: 25%; }
}',
            'meta_title'    => '',
            'meta_desc'     => '',
            'meta_keyword'  => '',
            'seo_url'       => array(
                0 => 'promotions'
            )
        ),
        'item'      => array( // Promotion item
            // settings
            'title'                         => array(),
            'rule_group'                    => '', // product etc
            'rule_type'                     => '', // buyxgetx etc
            'condition_min_quantity'        => 1,
            'condition_min_quantities'      => array(),
            'condition_min_amount'          => '',
            'condition_min_amounts'         => array(),
            'condition_min_orders'          => 3,
            'condition_product_ids'         => array(),
            'condition_category_ids'        => array(),
            'condition_manufacturer_ids'    => array(),
            'discount_quantity'             => 1,
            'discount_product_ids'          => array(),
            'discount_category_ids'         => array(),
            'discount_manufacturer_ids'     => array(),
            'discount_value'                => '',
            'discount_values'               => array(),
            'discount_type'                 => 'percentage',
            'discount_qualifier'            => 'least',
            'zone_ids'                      => array(),
            'limit_usage'                   => 0,
            'limit_max_usage'               => 10,
            'exclude_categories'            => 0,
            'excluded_category_ids'         => array(),
            'apply_once'                    => 0,
            'apply_special'                 => 1,
            'apply_coupon'                  => 0,
            'coupon_code'                   => '',
            'limit_customer_groups'         => 0,
            'customer_group_ids'            => array(0),
            'limit_customer_profile'        => 0,
            'customer_ids'                  => array(),
            'stores'                        => array(0),
            'stop'                          => 0,
            'meta'                          => array(
                'notes'                         => '',
                'apply_usage_per_customer'      => 0,
                'usage_per_customer'            => 2,
            ),
            'priority'                      => 1,
            'status'                        => 0,
            'date_start'                    => date('Y-m-d'),
            'date_end'                      => '',

            // design
            'design_status'                 => 0,
            'design_module_banner'          => '',
            'design_page_banner'            => '',
            'design_page_message'           => array(),

            // notification
            'message_congrats'              => array(),
            'message_eligible'              => array(),
            'message_upsell'                => array()
        ),
        'ntf_template' => array(
            // General
            'congrats'                      => $ntf_congrats = '<p>Congratulations! <b>{promo_name}</b> offer successfully applied!</p>',
            'eligible'                      => '<p>Your order qualifies for a free item! Select item {promo_items}!</p>',
            'upsell'                        => '<p>Orders that spend {condition_required} will qualify for <b>{promo_name}</b> offer. You have spent <b>{condition_match}</b>, spend <b>{condition_remain}</b> more to qualify.</p>',

            // Shipping
            'freeshippingwhenoverx_upsell'  => '<p>Spend at least {condition_required} will qualify for free shipping from <b>{promo_name}</b> offer. You have spent <b>{condition_match}</b>, spend <b>{condition_remain}</b> more to qualify.</p>',

            // Product
            'buyxgetx_congrats'             => '<p>Congratulations! <b>{promo_name}</b> offer for product {promo_items} successfully applied to cart!</p>',
            'buyxgetx_eligible'             => '<p>Products {promo_items} in shopping cart qualifies for a free item from <b>{promo_name}</b> offer, add {discount_quantity} more unit as free item!</p>',
            'buyxgetx_upsell'               => '<p>Products in shopping cart will qualifies for a free item from <b>{promo_name}</b> offer! Add more quantity at least {condition_required} unit for following products: {promo_items}.</p>',

            'buyxgety_congrats'             => $ntf_congrats,
            'buyxgety_eligible'             => '<p>Products {promo_items} in shopping cart qualifies for a free item from <b>{promo_name}</b> offer, add {discount_total} unit to your shopping cart from listed free product <a href="{promo_url}">here</a>.</p>',
            'buyxgety_upsell'               => '<p>Products in shopping cart will qualifies for a free item from <b>{promo_name}</b> offer! Buy more unit of products {promo_items} into total of {condition_required} unit or another products listed <a href="{promo_url}">here</a>.</p>',

            'buyxgetamountoffy_congrats'    => $ntf_congrats,
            'buyxgetamountoffy_eligible'    => '<p>Products {promo_items} in shopping cart qualifies for discounts off {discount_value} per unit from <b>{promo_name}</b> offer, add {discount_total} unit to your shopping cart from listed product <a href="{promo_url}">here</a>.</p>',
            'buyxgetamountoffy_upsell'      => '<p>Buy at least {condition_required} unit or more of products {promo_items} or combine with products listed <a href="{promo_url}">here</a> to qualifies for discounts off {discount_value} per unit of picked <a href="{promo_url}">products</a> from <b>{promo_name}</b> offer!</p>',

            'amountoffy_congrats'           => $ntf_congrats,
            'amountoffy_eligible'           => '<p>Products {promo_items} in shopping cart qualifies for discounts off {discount_value} per unit from <b>{promo_name}</b> offer, add {discount_total} unit to your shopping cart from listed product <a href="{promo_url}">here</a>.</p>',
            'amountoffy_upsell'             => '<p>Buy at least {condition_required} unit or more of products {promo_items} or another products listed <a href="{promo_url}">here</a> to qualifies for discounts off {discount_value} per unit from <b>{promo_name}</b> offer!</p>',

            // Manufacturer
            'xoffitemsinybrands_congrats'   => '<p>Congratulations! Discounts off {discount_value} per unit from <b>{promo_name}</b> offer successfully applied!</p>',

            'buyxgetysamebrands_congrats'   => '<p>Congratulations! {discount_quantity} free unit from <b>{promo_name}</b> offer successfully applied!</p>',
            'buyxgetysamebrands_eligible'   => '<p>Products {promo_items} in shopping cart qualifies for {discount_quantity} free unit from <b>{promo_name}</b> offer, add unit from same brands of products.</p>',
            'buyxgetysamebrands_upsell'     => '<p>Products {promo_items} in shopping cart will qualifies for {discount_quantity} free unit from <b>{promo_name}</b> offer! Buy more unit of total {condition_required} unit or another products in same brands.</p>',

            // Category
            'percentoffitemsincat_congrats'           => '<p>Congratulations! Discounts off {discount_value} per unit from <b>{promo_name}</b> offer successfully applied!</p>',

            'buyxgetysamecategory_congrats'           => '<p>Congratulations! {discount_quantity} free unit from <b>{promo_name}</b> offer successfully applied!</p>',
            'buyxgetysamecategory_eligible'           => '<p>Products {promo_items} in shopping cart qualifies for {discount_quantity} free unit from <b>{promo_name}</b> offer, add unit from same category of products.</p>',
            'buyxgetysamecategory_upsell'             => '<p>Products {promo_items} in shopping cart will qualifies for {discount_quantity} free unit from <b>{promo_name}</b> offer! Buy more unit of total {condition_required} unit or another products in same category.</p>',

            'buyxfromygetoffonz_congrats'             => $ntf_congrats,
            'buyxfromygetoffonz_eligible'             => '<p>Products {promo_items} in shopping cart qualifies for {discount_value} off from <b>{promo_name}</b> offer, add discounted unit to your shopping cart from listed product <a href="{promo_url}">here</a>.</p>',
            'buyxfromygetoffonz_upsell'               => '<p>Buy at least total of {condition_required} unit or more of products {promo_items} or another products listed <a href="{promo_url}">here</a> to qualifies for discounts off {discount_value} per unit from <b>{promo_name}</b> offer!</p>',

            'xoffitemsinycategoriestiered_congrats'   => '<p>Congratulations! Discounts off {discount_value} from <b>{promo_name}</b> offer successfully applied!</p>',
            'xoffitemsinycategoriestiered_upsell'     => '<p>Products in shopping cart will qualifies for tier discounts from <b>{promo_name}</b> offer! Buy at least total of {condition_required} unit fom category {category_list}.</p>',

            // Order
            'xamountoffwhenxormore_congrats'          => '<p>Congratulations! Discounts off {discount_value} from <b>{promo_name}</b> offer successfully applied!</p>',
            'xamountoffwhenxormore_upsell'            => '<p>To qualifies for discounts off {discount_value} from <b>{promo_name}</b>, shopping cart total must be at least {condition_required} (exclude tax).</p>',

            'ordersofatleastxgety_congrats'           => '<p>Congratulations! Discounts off {discount_value} from <b>{promo_name}</b> offer successfully applied!</p>',
            'ordersofatleastxgety_eligible'           => '<p>Your order amount qualifies for discounts off {discount_value} for one unit of picked <a href="{promo_url}">products</a> from <b>{promo_name}</b> offer!</p>',
            'ordersofatleastxgety_upsell'             => '<p>To qualifies for discounts off {discount_value} from <b>{promo_name}</b>, shopping cart total must be at least {condition_required} (exclude tax).</p>',

            'ordersofatleastxgetyoffleastormostexpensiveproduct_congrats' => '<p>Congratulations! Discounts off {discount_value} from <b>{promo_name}</b> offer successfully applied!</p>',
            'ordersofatleastxgetyoffleastormostexpensiveproduct_upsell'   => '<p>To qualifies for discounts off {discount_value} from <b>{promo_name}</b>, shopping cart total must be at least {condition_required} (exclude tax).</p>',

            // Customer
            'xoffforrepeatcustomers_congrats'         => $ntf_congrats,
            'xoffforrepeatcustomers_upsell'           => '<p>Customers that previously placed {condition_orders} orders and spend {condition_required} will qualify for <b>{promo_name}</b> offer. You have spent <b>{condition_match}</b>, spend <b>{condition_remain}</b> more to qualify.</p>',

            'xpercentoffforrepeatcustomers_congrats'  => $ntf_congrats,
            'xpercentoffforrepeatcustomers_upsell'    => '<p>Customers that previously placed {condition_orders} orders and spend {condition_required} will qualify for <b>{promo_name}</b> offer. You have spent <b>{condition_match}</b>, spend <b>{condition_remain}</b> more to qualify.</p>',
        )
    )
);
