<?php

class Netgsmsms
{
    private $usercode;
    private $password;
    private $title;
    private $language = '';

    public function __construct($usercode, $password, $title='', $trChar = '')
    {
        error_reporting(0);
        $this->usercode = $usercode;
        $this->password = $password;
        $this->title = $title;

        $this->language = '';
        if ($trChar == 1){
            $this->language = "dil='TR'";
        }
    }

    /*
     * N:N SMS gönderimi
     */
    public function bulkSMScustom($mesaj, $title)
    {
        $PostAdress = 'https://api.netgsm.com.tr/sms/send/xml';
        $xml='<?xml version="1.0" encoding="UTF-8"?>
              <mainbody>
                <header>
                  <company opcrd="1" '.$this->language.'>Netgsm</company>
                      <usercode>'.$this->usercode.'</usercode>
                      <password>'.$this->password.'</password>
                      <startdate></startdate>
                      <stopdate></stopdate>
                      <type>n:n</type>
                      <msgheader>'.$title.'</msgheader>
                      </header>
                  <body>
                    '.$mesaj.'</body>
                      </mainbody>';
        return $this->XMLPOST($PostAdress,$xml);
    }

    /*
     * Özel SMS
     */
    public function privateSMS($phone, $message, $title)
    {
        $PostAdress = 'https://api.netgsm.com.tr/sms/send/xml';
        $xml='<?xml version="1.0" encoding="UTF-8"?>
              <mainbody>
                <header>
                  <company opcrd="1" '.$this->language.'>Netgsm</company>
                      <usercode>'.$this->usercode.'</usercode>
                      <password>'.$this->password.'</password>
                      <startdate></startdate>
                      <stopdate></stopdate>
                      <type>1:n</type>
                      <msgheader>'.$title.'</msgheader>
                      </header>
                  <body>
                      <msg><![CDATA['.$message.']]></msg>
                      <no>'.$this->getphoneClear($phone).'</no>
                  </body>
                      </mainbody>';
        return $this->XMLPOST($PostAdress,$xml);
    }

    /*
     * Programlanmış smsleri gönderir
     */
    public function sendSMS($phoneDatas, $message){
        $phones = [];
        $exp = explode(',',$phoneDatas);
        foreach ($exp as $b){
           if($b!=''){
               $phones[] = $b;
           }
        }

        $PostAdress = 'https://api.netgsm.com.tr/sms/send/xml';
        $xml='<?xml version="1.0" encoding="UTF-8"?>
<mainbody>
	<header>
		<company opcrd="1" '.$this->language.' >NETGSM</company>
        <usercode>'.$this->usercode.'</usercode>
        <password>'.$this->password.'</password>
		<startdate></startdate>
		<stopdate></stopdate>
	    <type>1:n</type>
        <msgheader>'.$this->title.'</msgheader>
        </header>
		<body>
		<msg><![CDATA['.$message.']]></msg>';
		foreach ($phones as $phone){
            $xml.='<no>'.$phone.'</no>';
        }
		$xml.='</body>
</mainbody>';
        return $this->XMLPOST($PostAdress,$xml);
    }

    public function getSmsBaslik(){
        $PostAdress = 'https://api.netgsm.com.tr/get_msgheader.asp?usercode='.$this->usercode.'&password='.$this->password;
        $result = $this->XMLPOST($PostAdress,'');
        return $this->getSmsBaslikSonuc($result);
    }

    public function getKredi(){
        $PostAdress = 'https://api.netgsm.com.tr/balance/list/xml';
        $xml = "<?xml version='1.0'?><mainbody><header><company>Netgsm</company><usercode>".$this->usercode."</usercode><password>".$this->password."</password><stip>2</stip></header></mainbody>";
        $result = $this->XMLPOST($PostAdress,$xml);
        return $this->getKrediSonuc($result);
    }

    /*
     * Netsantral Reporları
     * Dakikada en fazla 2 kez sorgulanabilir
     */
    public function getVoipReport()
    {
        date_default_timezone_set('Europe/Istanbul');
        $startDate = date('dmYHi', time() - 60*60*24);
        $endDate = date('dmYHi', time());
        $PostAdress = 'https://api.netgsm.com.tr/netsantral/report/xml';
        $xml = "<?xml version='1.0'?>
            <mainbody>
                <header>
                    <company>Netgsm</company>
                    <usercode>".$this->usercode."</usercode>
                    <password>".$this->password."</password>
                    <startdate>".$startDate."</startdate>
                    <stopdate>".$endDate."</stopdate>
                    <version>3</version>
                </header>
            </mainbody>";
        $results = $this->XMLPOST($PostAdress,$xml);

        if ($results != '' && in_array(trim($results), [100,101])){
            $response = ['error'=>['code'=>trim($results), 'message'=>'Dakikada en fazla 2 kez sorgulanabilir.']];
            return json_encode($response,256);
        }
        if ($results != '' && in_array(trim($results), [40])){
            $response = ['error'=>['code'=>trim($results), 'message'=>'Listelenecek kayıt yok.']];
            return json_encode($response,256);
        }
        if ($results != '' && in_array(trim($results), [30])){
            $response = ['error'=>['code'=>trim($results), 'message'=>'Geçersiz kullanıcı adı, şifre veya kullanıcınızın API erişim izniniz yok.']];
            return json_encode($response,256);
        }

        if ($results != '' && in_array(trim($results), [50])){
            $response = ['error'=>['code'=>trim($results), 'message'=>'Tarih formatının hatalı.']];
            return json_encode($response,256);
        }

        if ($results != '' && in_array(trim($results), [60])){
            $response = ['error'=>['code'=>trim($results), 'message'=>'Zaman farkının 7 günden fazla']];
            return json_encode($response,256);
        }

        if ($results != '' && in_array(trim($results), [70])){
            $response = ['error'=>['code'=>trim($results), 'message'=>'Hatalı sorgulama.']];
            return json_encode($response,256);
        }

        if ($results != '' && in_array(trim($results), [80])){
            $response = ['error'=>['code'=>trim($results), 'message'=>'Netsantral hizmeti kullanılmıyor.']];
            return json_encode($response,256);
        }

        $results = explode('<br/>', $results);

        $response = [];
        foreach ($results as $result) {
            $result = trim($result);
            $cdr = explode('|', $result);
            $temp = [];
            if(isset($cdr[0]) && $cdr[0] != '') {
                $temp['call_id'] = $cdr[0];
                $temp['date'] = $cdr[1];
                $temp['dial_number'] = $cdr[2];
                $temp['caller_number'] = $cdr[3];
                $temp['time'] = $cdr[4];
                $temp['direction'] = $cdr[5];
                //$temp['recording'] = $cdr[6];
                array_push($response, $temp);
            }
        }
        $json['success'] = ['message'=>'Son 24 saatin kayıtları listeleniyor.'];
        $json['data'] = $response;

        return json_encode($json,256);
    }

    /*
     * Santral Raporları (Sabit Telefon)
     * Dakikada en fazla 2 kez sorgulanabilir
     */
    public function getPhoneReport()
    {
        date_default_timezone_set('Europe/Istanbul');
        $startDate = date('dmYHi', time() - 60*60*24);
        $endDate = date('dmYHi', time());
        $PostAdress = 'https://api.netgsm.com.tr/voice/report/xml';
        $xml = "<?xml version='1.0'?>
            <mainbody>
                <header>
                    <company>Netgsm</company>
                    <usercode>".$this->usercode."</usercode>
                    <password>".$this->password."</password>
                    <date></date>
                    <direction>4</direction>
                </header>
            </mainbody>";
        $results = $this->XMLPOST($PostAdress,$xml);

        if ($results != '' && in_array(trim($results), [100,101])){
            $response = ['error'=>['code'=>trim($results), 'message'=>'Dakikada en fazla 2 kez sorgulanabilir.']];
            return json_encode($response,256);
        }
        if ($results != '' && in_array(trim($results), [40])){
            $response = ['error'=>['code'=>trim($results), 'message'=>'Listelenecek kayıt yok.']];
            return json_encode($response,256);
        }
        if ($results != '' && in_array(trim($results), [30])){
            $response = ['error'=>['code'=>trim($results), 'message'=>'Geçersiz kullanıcı adı, şifre veya kullanıcınızın API erişim izniniz yok.']];
            return json_encode($response,256);
        }

        if ($results != '' && in_array(trim($results), [50])){
            $response = ['error'=>['code'=>trim($results), 'message'=>'Tarih formatının hatalı.']];
            return json_encode($response,256);
        }

        if ($results != '' && in_array(trim($results), [70])){
            $response = ['error'=>['code'=>trim($results), 'message'=>'Hatalı sorgulama.']];
            return json_encode($response,256);
        }


        $results = explode('<br/>', $results);

        $response = [];
        foreach ($results as $result) {
            $result = trim($result);
            $cdr = explode(' | ', $result);
            $temp = [];
            if(isset($cdr[0]) && $cdr[0] != '') {
                $temp['caller_number'] = $cdr[0];
                $temp['date'] = $cdr[1];
                $temp['time'] = $cdr[2];
                $temp['direction'] = $cdr[3];
                array_push($response, $temp);
            }
        }
        $json['success'] = ['message'=>'Bugünün kayıtları listeleniyor.'];
        $json['data'] = $response;

        return json_encode($json,256);
    }

    private function XMLPOST($PostAddress,$xmlData)
    {
        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL,$PostAddress);
       // curl_setopt($ch, CURLOPT_SSL_VERIFYHOST,1);
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER,0);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER,1);
        curl_setopt($ch, CURLOPT_HTTPHEADER, Array("Content-Type: text/xml"));
        curl_setopt($ch, CURLOPT_TIMEOUT, 30);
        curl_setopt($ch, CURLOPT_POSTFIELDS, $xmlData);
        $result = curl_exec($ch);
        return $result;
    }

    private function getSmsBaslikSonuc($result){
        if($result==30){
            return 'Geçersiz kullanıcı adı , şifre veya kullanıcınızın API erişim izninin olmadığını gösterir.
Ayrıca eğer API erişiminizde IP sınırlaması yaptıysanız ve sınırladığınız ip dışında gönderim sağlıyorsanız 30 hata kodunu alırsınız. API erişim izninizi veya IP sınırlamanızı , web arayüzümüzden; sağ üst köşede bulunan ayarlar> API işlemleri menüsunden kontrol edebilirsiniz.';
        }else{
            $array = explode('<br>',$result);
            return $array;
        }
    }

    private function getKrediSonuc($result){
        $array = explode(' ',$result);
        $errorcode = $array[0];
        if($errorcode==30){
            $message = '30Geçersiz kullanıcı adı , şifre veya kullanıcınızın API erişim izninin olmadığını gösterir.
Ayrıca eğer API erişiminizde IP sınırlaması yaptıysanız ve sınırladığınız ip dışında gönderim sağlıyorsanız 30 hata kodunu alırsınız. API erişim izninizi veya IP sınırlamanızı , web arayüzümüzden; sağ üst köşede bulunan ayarlar> API işlemleri menüsunden kontrol edebilirsiniz.';
        }elseif($errorcode==40){
            $message = '40Arama kriterlerinize göre listelenecek kayıt olmadığını ifade eder.';
        }elseif($errorcode==70){
            $message = '70Hatalı sorgulama. Gönderdiğiniz parametrelerden birisi hatalı veya zorunlu alanlardan birinin eksik olduğunu ifade eder.';
        }else{
            $message = '99'.$array[1];
           //if(isset($bol[2])){
           //    $mesaj.=' '.$bol[2];
           //
           //}
        }

        return $message;
    }

    public function getPaket(){
        $PostAdress = 'https://api.netgsm.com.tr/balance/list/xml';
        $xml = "<?xml version='1.0'?><mainbody><header><company>Netgsm</company><usercode>".$this->usercode."</usercode><password>".$this->password."</password><stip>1</stip></header></mainbody>";
        $result = $this->XMLPOST($PostAdress,$xml);
        if($result==30){
            return '-';
        }
        return $result;
    }

    /*
     * Rehbere kaydeder
     */
    public function grubakaydet($first_name, $last_name, $phone, $group_name= 'Müşteriler')
    {
        $xml = '<?xml version="1.0" encoding="iso-8859-9"?>
        <main>
            <usercode>'.$this->usercode.'</usercode>
            <pwd>'.$this->password.'</pwd>
            <grup>'.$group_name.'</grup>
            <tel>
                <ad><![CDATA['.$first_name.']]></ad>
                <soyad><![CDATA['.$last_name.']]></soyad>
                <telefon><![CDATA['.$phone.']]></telefon>
            </tel>
        </main>';
        $response = $this->XMLPOST( 'http://api.netgsm.com.tr/contacts/group/add', $xml );
        return $response;
    }

    public function setContact($datas, $groupName = 'Opencart')
    {
        if (count($datas)>500){
            $contacts = array_chunk($datas, 500);
            foreach ($contacts as $contact) {
                $this->addContacts($contact, $groupName);
            }
        } else {
            return $this->addContacts($datas, $groupName);
        }
        return true;
    }

    public function addContacts($datas, $groupName = 'Opencart')
    {
        $body = '';
        foreach ($datas as $data) {
            $telephone = $this->getphoneClear($data['telephone']);
            $body .= '<tel>
                <ad><![CDATA['.$data['firstname'].']]></ad>
                <soyad><![CDATA['.$data['lastname'].']]></soyad>
                <telefon><![CDATA['.$telephone.']]></telefon>
            </tel>';
        }

        $xml = '<?xml version="1.0" encoding="iso-8859-9"?>
        <main>
            <usercode>'.$this->usercode.'</usercode>
            <pwd>'.$this->password.'</pwd>
            <grup>'.$groupName.'</grup>
           '.$body.'
        </main>';
        $response = $this->XMLPOST( 'http://api.netgsm.com.tr/contacts/group/add', $xml );
        return $response;
    }

    public function netgsm_GetKredi($user,$pass) {
        $response = file_get_contents("https://api.netgsm.com.tr/get_kredi.asp?usercode=$user&password=$pass" );
        $data = explode(' ', $response);
        if($data[0]!='30') {
            if(isset($data[2]) && isset($data[2])=='AdetSMS')
                $tip = 'SMS';
            else
                $tip = 'Kredi';
            if ($data[1] > 0) {
                $result = array('giris'=>'success', 'durum' => 'success', 'mesaj'=>'', 'kredi' => round($this->virgulduzelt($data[1]),2), 'tipmsj' => ' Krediniz');
            } else {
                $result = array('giris'=>'success', 'durum' => 'warning', 'mesaj'=>' Bakiye Satın Al',  'kredi' => $data[1],  'tipmsj' => ' Kalan '.$tip);
            }
        }
        else{
            $result = array('giris'=>'error', 'durum'=>'error', 'mesaj'=>'Geçersiz kullanıcı adı , şifre veya kullanıcınızın API erişim izninin olmadığını gösterir.');
        }
        return $result;
    }

    public function netgsm_GetPaket($user,$pass) {
        $response = file_get_contents( "https://api.netgsm.com.tr/get_kredi.asp?usercode=$user&password=$pass&tip=1" );
        $data = explode(' ', $response);
        if($data[0]=='30') {
            $result = array('giris'=>'error', 'durum'=>'error', 'mesaj'=>'Geçersiz kullanıcı adı , şifre veya kullanıcınızın API erişim izninin olmadığını gösterir.');
        }
        elseif ($data[0]=='40') {
            $result = array('giris'=>'success', 'durum'=>'error', 'mesaj'=>'Arama kriterlerinize göre listelenecek kayıt olmadığını ifade eder.');
        }
        else {
            if ($data[0] > 0) {
                $result = array('giris'=>'success', 'durum' => 'success', 'mesaj'=>'', 'kredi' => $data[0], 'tipmsj' => ' Kalan SMS'); // sms
            }
            else{
                $result = array('giris'=>'success', 'durum' => 'warning', 'mesaj'=>' Bakiye Satın Al', 'kredi' => $data[0], 'tipmsj' => ' Kalan SMS');
            }
        }
        return $result;
    }

    public function netgsm_GirisSorgula($user,$pass)
    {
        $response = $this->netgsm_GetKredi($user,$pass);

        if($response['giris']=='success') {     //Giriş Başarılı
            if($response['durum']=='success') {  //kredi varsa
                $result = array('durum' => 'success',
                    'icon' => 'fa-chech',
                    'mesaj' => "<i class='fa fa-diamond'></i> ".$response['tipmsj']." : ".$response['kredi'],
                    'btnkontrol'=>'enabled',
                    'href'=>'' );
            }
            else{ //kredi yoksa
                $getpackage = $this->netgsm_GetPaket($user,$pass);
                if($getpackage['giris']=='success') {    //giriş başarılı
                    if($getpackage['durum']=='success') {  //kredi varsa
                        $result = array('durum' => 'success',
                            'icon' => 'fa-check',
                            'mesaj' => "<i class='fa fa-envelope-o'></i> ". ' SMS Bakiyeniz : '.$response['kredi'],
                            'btnkontrol'=>'enabled',
                            'href'=>'' );
                    }
                    else { //kredi yoksa satın almaya yönlendir (Hem kredi hem paket yok.)
                        $result = array('durum' => 'warning',
                            'icon' => 'fa-shopping-cart',
                            'mesaj' => ' Krediniz:'.$response['kredi'].'. Kredi satın al <i class=\'fa fa-external-link\'></i>',
                            'btnkontrol'=>'enabled',
                            'href'=>'https://www.netgsm.com.tr/webportal/satis_arayuzu/paketler.php' );
                    }
                }
            }
        }
        else { // giriş başarısız
            if(empty($user) && !empty($pass))
                $message = " Kullanıcı adı alanı boş.";
            elseif (empty($pass) && !empty($user))
                $message = " Şifre alanı boş.";
            elseif (empty($user) && empty($pass))
                $message = " Kullanıcı adı & şifre boş.";
            else {
                $message = " Kullanıcı adı veya şifreniz hatalı.";
            }
            $result = array('durum' => 'danger',
                'icon' => 'fa-exclamation-triangle',
                'mesaj' => $message,
                'btnkontrol' => 'disabled',
                'href' => '');
        }
        return json_encode($result);
    }
    private function virgulduzelt($gelen){
        return str_replace(",", ".", $gelen);
    }

    public function inbox(){
        $xml = '<?xml version="1.0"?>
                    <mainbody>
                        <header>
                            <company>Netgsm</company>
                            <usercode>'.$this->usercode.'</usercode>
                            <password>'.$this->password.'</password>
                            <startdate>'.date('dmYHi', time() - 60*60*24*30).'</startdate>
                            <stopdate>'.date('dmYHi', time() + 60*60*24+60).'</stopdate>
                            <type>0</type>
                        </header>
                    </mainbody>';
        $response = $this->XMLPOST( 'https://api.netgsm.com.tr/sms/receive/xml', $xml );
        return $this->inboxResponse($response);
    }

    private function inboxResponse($data){
        $result = array();
        $result['status']  =  "400";
        $i = 1;
        if($data == 30){
            $result['message'] = " Geçersiz kullanıcı adı , şifre veya kullanıcınızın API erişim izninin olmadığını gösterir.
Ayrıca eğer API erişiminizde IP sınırlaması yaptıysanız ve sınırladığınız ip dışında gönderim sağlıyorsanız 30 hata kodunu alırsınız. API erişim izninizi veya IP sınırlamanızı , web arayüzümüzden; sağ üst köşede bulunan ayarlar> API işlemleri menüsunden kontrol edebilirsiniz.";
        }
        elseif ($data == 40){
            $result['message'] = " Gösterilecek mesajınızın olmadığını ifade eder. Api ile mesajlarınızı eğer startdate ve stopdate parametlerini kullanmıyorsanız sadece bir kere listeyebilirsiniz. Listelenen mesajlar diğer sorgulamalarınızda gelmez.";
        }
        elseif ($data == 50){
            $result['message'] = " Tarih formatı hatalıdır.";
        }
        elseif ($data == 60){
            $result['message'] = " Arama kiterlerindeki startdate ve stopdate zaman farkının 30 günden fazla olduğunu ifade eder.";
        }
        elseif ($data == 70){
            $result['message'] = " Hatalı sorgulama. Gönderdiğiniz parametrelerden birisi hatalı veya zorunlu alanlardan birinin eksik olduğunu ifade eder.";
        }
        else {
            $parts = explode('<br>', $data);

            $result['status']  =  "200";

            foreach ($parts as $part) {
                $messages = explode(' | ', $part);
                $result[$i]['phone'] = $messages[0];
                $result[$i]['message'] = $messages[1];
                $result[$i]['time'] = $messages[2];
                $i++;
            }
        }

        return ($result);
    }

    public function getphoneClear($phone){
        $unwanted = array(' ', '+', '(', ')', '.', '-', '&amp;', 'nbsp;'  );
        $replace    = array('', '', '', '', '', '', '', '' );
        $result      = str_replace($unwanted, $replace, $phone);
        return $result;
    }

    public function login()
    {
        $result = $this->errorCodesforLoginStip2();

        $response = [];
        if ($result['code'] == '00'){
            if (isset($result['data']['kredi'])){
                $response['kredi']['quantity'] = $result['data']['kredi'];
                $response['type'] = 'TL';

            }
            if (isset($result['data']['sms'])){
                $response['SMS']['quantity'] = $result['data']['sms'];
                $response['SMS']['type'] = 'Adet';
            }
            $result['message']= 'Giriş Başarılı';
        } else {
            if ($result['login']=='error'){
                $response['message'] = 'Giriş Yapılmadı.';
            } else {
                $response['message'] = $result['message'];
            }
        }
        return json_encode($response);
    }

    public function getCredit($stip)    //1 gönderirsen sms bilgisi 2 gönderirsen kredi bilgisi
    {
        $xml = "<?xml version='1.0'?>
                    <mainbody>
                    <header>
                    <company>Netgsm</company>
                    <usercode>$this->usercode</usercode>
                    <password>$this->password</password>
                    <stip>$stip</stip>
                    </header>
                    </mainbody>";
        $result = $this->XMLPOST('https://api.netgsm.com.tr/balance/list/xml', $xml);
        return $result;
    }

    public function errorCodesforLoginStip1($credit)
    {
        $response = 0;
        $results = explode('<BR>', $credit);
        foreach ($results as $result) {
            $result = explode(' | ', $credit);
            if ($result[0] > 0 && $result[1] == 'Adet' && $result[2] = 'Sms' ){
                $response = $result[0];
            } else {
                $response = 0;
            }
        }
        return $response;
    }

    public function errorCodesforLoginStip2()
    {
        $credit = $this->getCredit(2);
        $result = explode(' ', $credit);
        $login = $result[0]=='00'?'success':'error';
        switch ($result[0]){
            case '30':
                $response = ['status'=>'error', 'code'=> 30,'message'=>'Geçersiz kullanıcı adı , şifre veya kullanıcınızın API erişim izninin olmadığını gösterir.
Ayrıca eğer API erişiminizde IP sınırlaması yaptıysanız ve sınırladığınız ip dışında gönderim sağlıyorsanız 30 hata kodunu alırsınız. API erişim izninizi veya IP sınırlamanızı , web arayüzümüzden; sağ üst köşede bulunan ayarlar> API işlemleri menüsunden kontrol edebilirsiniz'];
                break;
            case '40':
                $response = ['status'=>'error', 'code'=> 40,'message'=>'Arama kriterlerinize göre listelenecek kayıt olmadığını ifade eder.'];
                break;
            case '100':
                $response = ['status'=>'error', 'code'=> 100,'message'=>'Sistem hatası, sınır aşımı.(dakikada en fazla 5 kez sorgulanabilir.)'];
                break;
            case '00':
                $response = ['status'=>'success', 'code'=>'00', 'message'=>'', 'data'=> $this->getCreditCheck($result)];
                break;
            default:
                $response = ['status'=>'error', 'code'=>'', 'message'=>'Belirlenemeyen durum oluştu.'];
                break;
        }
        $response['login'] = $login;

        return $response;
    }
    private function getCreditCheck($data)
    {
        $response = [];
        if ($data[0] == '00' && isset($data[2])){
            if ($data[2] == 'AdetSMS' && $data[1] > 0){
                $response['sms']=$data[1];
            }
        }
        if ($data[0] == '00' && !isset($data[2])){
            if ($data[1]>'0,000001'){
                $response['kredi'] = $data[1];
                $credit = $this->getCredit(1);
                if ($this->errorCodesforLoginStip1($credit)>0){
                    $response['sms'] = $this->errorCodesforLoginStip1($credit);
                }
            }
        }
        return $response;
    }



}