<?php

namespace Opencartvip\Utils;

class Profiler {

	private static $keys = array();

	public static function start($key) {
		if (static::isOpencartvipKey($key)) {
			static::$keys[$key] = Arr::get(static::$keys, $key, 0) - round(microtime(true) * 1000);
		}
	}

	public static function end($key) {
		if (static::isOpencartvipKey($key)) {
			static::$keys[$key] = Arr::get(static::$keys, $key, 0) + round(microtime(true) * 1000);
		}
	}

	public static function getStats() {
		return static::$keys;
	}

	private static function isOpencartvipKey($key) {
		return strpos($key, 'opencartvip') !== false;
	}

}
